#include "Application.h"
#include "Controller.h"

/*---- DEFINES --------------------------------------------------------------------------------------------*/
#define rtInf                          (100000000000000000.000000)
#define rtMinusInf                     (-100000000000000000.000000)

/*---- CALIBRATION ----------------------------------------------------------------------------------------*/
#include <Pragma_Section_Start_rodata_cals.h>
#include <Pragma_Section_End_rodata.h>

/*---- RAM VARIABLES --------------------------------------------------------------------------------------*/
#include <Pragma_Section_Start_sbss_zerovars.h>

/* Name: ProcessorReboot ClassID:ENUMVAR StorageID:RAM Access:RW4+RW3+RW2+RW1 TypeID:UINT1 CType:Volatile_T Struct:VolatileWork.mh_ProcessorReboot Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:0.000000
   Max:1.000000 Format:1.0 UpdateID:BACKGND Group:"System | Main Power Relay" Help:"Reboots the processor when set."  EnumDec:VarDecEnum_0 */

/* Name: ECUP_Threshold ClassID:VAR StorageID:FLASH Access:RW4+RW3+RW2+RW1 TypeID:UINT2 CType:Constant_T Struct:ConstantWork.mh_ECUP_Threshold Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:0.000000
   Max:1023.000000 Format:5.0 UpdateID:BACKGND Group:"System | Main Power Relay | Main Power Relay Config" Help:"ADC voltage threshold above which ECU is considered powered" Unit:ADC_counts  */

/* Name: MPRD_new ClassID:ENUMVAR StorageID:RAM Access:RW4+RW3+RW2+RW1 TypeID:UINT1 CType:Volatile_T Struct:VolatileWork.mh_MPRD_new Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:0.000000
   Max:1.000000 Format:1.0 UpdateID:BACKGND Group:"System | Main Power Relay | MPRD Override" Help:"Directly Override Main Power Relay" Unit:boolean EnumDec:VarDecEnum_1 */

/* Name: MPRD_ovr ClassID:ENUMVAR StorageID:RAM Access:RW4+RW3+RW2+RW1 TypeID:UINT1 CType:Volatile_T Struct:VolatileWork.mh_MPRD_ovr Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:0.000000
   Max:1.000000 Format:1.0 UpdateID:BACKGND Group:"System | Main Power Relay | MPRD Override" Help:""  EnumDec:VarDecEnum_2 */

/* Name: RestoreNVFactoryDefaults ClassID:ENUMVAR StorageID:RAM Access:RW4+RW3+RW2+RW1 TypeID:UINT1 CType:Volatile_T Struct:VolatileWork.mh_RestoreNVFactoryDefaults Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:0.000000
   Max:1.000000 Format:1.0 UpdateID:BACKGND Group:"System | NonVolatile Storage" Help:"Restores NonVolatile Memory to Factory Defaults"  EnumDec:VarDecEnum_3 */

/* Name: StoreNV ClassID:ENUMVAR StorageID:RAM Access:RW4+RW3+RW2+RW1 TypeID:UINT1 CType:Volatile_T Struct:VolatileWork.mh_StoreNV Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:0.000000
   Max:1.000000 Format:1.0 UpdateID:BACKGND Group:"System | NonVolatile Storage" Help:"Stores RAM-Shadowed memory to serial EEPROM"  EnumDec:VarDecEnum_4 */

/* Name: MPRD ClassID:ENUMVAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:UINT1 CType:Volatile_T Struct:VolatileWork.mh_MPRD Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:0.000000
   Max:1.000000 Format:1.0 UpdateID:BACKGND Group:"System | Main Power Relay" Help:"Indicates whether the main power relay is active"  EnumDec:VarDecEnum_5 */

/* Name: MPRD_KeepAlive ClassID:ENUMVAR StorageID:RAM Access:RW4+RW3+RW2+RW1 TypeID:UINT1 CType:Volatile_T Struct:VolatileWork.mh_MPRD_KeepAlive Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:0.000000
   Max:1.000000 Format:1.0 UpdateID:BACKGND Group:"System | Main Power Relay" Help:"When enabled, keeps the MPRD output on and keeps the processor alive"  EnumDec:VarDecEnum_6 */

/* Name: Battery_Current_A ClassID:VAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:REAL4 CType:BlockIO_Controller Struct:Controller_B.s1_ReadCANMessage_o3 Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:-100000000000000000.000000
   Max:100000000000000000.000000 Format:4.2 UpdateID:BACKGND Group:"Controller|Foreground|Probes" Help:""   */

/* Name: Battery_SOC ClassID:VAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:REAL4 CType:BlockIO_Controller Struct:Controller_B.s1_ReadCANMessage_o1 Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:-100000000000000000.000000
   Max:100000000000000000.000000 Format:4.2 UpdateID:BACKGND Group:"Controller|Foreground|Probes" Help:""   */

/* Name: Motor_rpm ClassID:VAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:REAL4 CType:BlockIO_Controller Struct:Controller_B.s1_ReadCANMessage3_o1 Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:-100000000000000000.000000
   Max:100000000000000000.000000 Format:4.2 UpdateID:BACKGND Group:"Controller|Foreground|Probes" Help:""   */

/* Name: Motor_Torque_Nm ClassID:VAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:REAL4 CType:BlockIO_Controller Struct:Controller_B.s1_ReadCANMessage3_o3 Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:-100000000000000000.000000
   Max:100000000000000000.000000 Format:4.2 UpdateID:BACKGND Group:"Controller|Foreground|Probes" Help:""   */

/* Name: Vehicle_Speed_mph ClassID:VAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:REAL4 CType:BlockIO_Controller Struct:Controller_B.s1_secondsperhour Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:-100000000000000000.000000
   Max:100000000000000000.000000 Format:4.2 UpdateID:BACKGND Group:"Controller|Foreground|Probes" Help:""   */

/* Name: Battery_Pack_State ClassID:VAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:REAL4 CType:BlockIO_Controller Struct:Controller_B.s1_ReadCANMessage4 Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:-100000000000000000.000000
   Max:100000000000000000.000000 Format:4.2 UpdateID:BACKGND Group:"Controller|Foreground|Probes" Help:""   */

/* Name: GEN_State ClassID:VAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:REAL4 CType:BlockIO_Controller Struct:Controller_B.s1_ReadCANMessage5 Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:-100000000000000000.000000
   Max:100000000000000000.000000 Format:4.2 UpdateID:BACKGND Group:"Controller|Foreground|Probes" Help:""   */

/* Name: Motor_State ClassID:VAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:REAL4 CType:BlockIO_Controller Struct:Controller_B.s1_ReadCANMessage6 Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:-100000000000000000.000000
   Max:100000000000000000.000000 Format:4.2 UpdateID:BACKGND Group:"Controller|Foreground|Probes" Help:""   */

/* Name: Battery_Voltage_V ClassID:VAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:REAL4 CType:BlockIO_Controller Struct:Controller_B.s1_ReadCANMessage_o2 Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:-100000000000000000.000000
   Max:100000000000000000.000000 Format:4.2 UpdateID:BACKGND Group:"Controller|Foreground|Probes" Help:""   */

/* Name: Engine_Fuel_Rate_gps ClassID:VAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:REAL4 CType:BlockIO_Controller Struct:Controller_B.s1_ReadCANMessage2_o2 Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:-100000000000000000.000000
   Max:100000000000000000.000000 Format:4.2 UpdateID:BACKGND Group:"Controller|Foreground|Probes" Help:""   */

/* Name: Measured_Engine_rpm ClassID:VAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:REAL4 CType:BlockIO_Controller Struct:Controller_B.s1_ReadCANMessage2_o1 Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:-100000000000000000.000000
   Max:100000000000000000.000000 Format:4.2 UpdateID:BACKGND Group:"Controller|Foreground|Probes" Help:""   */

/* Name: Engine_Torque_Nm ClassID:VAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:REAL4 CType:BlockIO_Controller Struct:Controller_B.s1_ReadCANMessage2_o3 Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:-100000000000000000.000000
   Max:100000000000000000.000000 Format:4.2 UpdateID:BACKGND Group:"Controller|Foreground|Probes" Help:""   */

/* Name: Generator_Current_A ClassID:VAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:REAL4 CType:BlockIO_Controller Struct:Controller_B.s1_ReadCANMessage1_o2 Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:-100000000000000000.000000
   Max:100000000000000000.000000 Format:4.2 UpdateID:BACKGND Group:"Controller|Foreground|Probes" Help:""   */

/* Name: Generator_rpm ClassID:VAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:REAL4 CType:BlockIO_Controller Struct:Controller_B.s1_ReadCANMessage1_o1 Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:-100000000000000000.000000
   Max:100000000000000000.000000 Format:4.2 UpdateID:BACKGND Group:"Controller|Foreground|Probes" Help:""   */

/* Name: Generator_Torque_Nm ClassID:VAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:REAL4 CType:BlockIO_Controller Struct:Controller_B.s1_ReadCANMessage1_o3 Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:-100000000000000000.000000
   Max:100000000000000000.000000 Format:4.2 UpdateID:BACKGND Group:"Controller|Foreground|Probes" Help:""   */

/* Name: Motor_Current_A ClassID:VAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:REAL4 CType:BlockIO_Controller Struct:Controller_B.s1_ReadCANMessage3_o2 Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:-100000000000000000.000000
   Max:100000000000000000.000000 Format:4.2 UpdateID:BACKGND Group:"Controller|Foreground|Probes" Help:""   */

/* Name: Driver_Accel_Request ClassID:VAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:REAL4 CType:BlockIO_Controller Struct:Controller_B.s1_Sum Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:-100000000000000000.000000
   Max:100000000000000000.000000 Format:4.2 UpdateID:BACKGND Group:"Controller|Foreground|Probes" Help:""   */

/* Name: Vehicle_Key ClassID:VAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:REAL4 CType:Volatile_T Struct:VolatileWork.mh_Vehicle_Key Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:-100000000000000000.000000
   Max:100000000000000000.000000 Format:4.2 UpdateID:BACKGND Group:"Controller|Foreground|Probes" Help:""   */

/* Name: Driver_Brake_Request ClassID:VAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:REAL4 CType:BlockIO_Controller Struct:Controller_B.s1_Sum1 Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:-100000000000000000.000000
   Max:100000000000000000.000000 Format:4.2 UpdateID:BACKGND Group:"Controller|Foreground|Probes" Help:""   */

/* Name: Park_PB ClassID:VAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:REAL4 CType:BlockIO_Controller Struct:Controller_B.s1_DataTypeConversion8 Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:-100000000000000000.000000
   Max:100000000000000000.000000 Format:4.2 UpdateID:BACKGND Group:"Controller|Foreground|Probes" Help:""   */

/* Name: Forward_PB ClassID:VAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:REAL4 CType:BlockIO_Controller Struct:Controller_B.s1_DataTypeConversion9 Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:-100000000000000000.000000
   Max:100000000000000000.000000 Format:4.2 UpdateID:BACKGND Group:"Controller|Foreground|Probes" Help:""   */

/* Name: Reverse_PB ClassID:VAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:REAL4 CType:BlockIO_Controller Struct:Controller_B.s1_DataTypeConversion10 Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:-100000000000000000.000000
   Max:100000000000000000.000000 Format:4.2 UpdateID:BACKGND Group:"Controller|Foreground|Probes" Help:""   */

/* Name: Speed_Feedback_P_Gain ClassID:VAR StorageID:FLASH Access:RW4+RW3+RW2+RW1 TypeID:REAL4 CType:Constant_T Struct:ConstantWork.mh_Speed_Feedback_P_Gain Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:-100000000000000000.000000
   Max:100000000000000000.000000 Format:4.2 UpdateID:BACKGND Group:"Controller|Foreground|Control" Help:""   */

/* Name: Generator_Torque ClassID:VAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:REAL4 CType:BlockIO_Controller Struct:Controller_B.s3_Product Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:-100000000000000000.000000
   Max:100000000000000000.000000 Format:4.2 UpdateID:BACKGND Group:"Controller|Foreground|Probes1" Help:""   */

/* Name: Engine_On ClassID:VAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:REAL4 CType:BlockIO_Controller Struct:Controller_B.s12_Engine_On Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:-100000000000000000.000000
   Max:100000000000000000.000000 Format:4.2 UpdateID:BACKGND Group:"Controller|Foreground|Probes1" Help:""   */

/* Name: Reverse_LED ClassID:VAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:REAL4 CType:BlockIO_Controller Struct:Controller_B.s19_Reverse_LED Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:-100000000000000000.000000
   Max:100000000000000000.000000 Format:4.2 UpdateID:BACKGND Group:"Controller|Foreground|Probes1" Help:""   */

/* Name: Error ClassID:VAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:REAL4 CType:BlockIO_Controller Struct:Controller_B.s19_Error Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:-100000000000000000.000000
   Max:100000000000000000.000000 Format:4.2 UpdateID:BACKGND Group:"Controller|Foreground|Probes1" Help:""   */

/* Name: Vehicle_Ready ClassID:VAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:REAL4 CType:BlockIO_Controller Struct:Controller_B.s19_Vehicle_Ready Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:-100000000000000000.000000
   Max:100000000000000000.000000 Format:4.2 UpdateID:BACKGND Group:"Controller|Foreground|Probes1" Help:""   */

/* Name: State ClassID:VAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:REAL4 CType:BlockIO_Controller Struct:Controller_B.s19_State Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:-100000000000000000.000000
   Max:100000000000000000.000000 Format:4.2 UpdateID:BACKGND Group:"Controller|Foreground|Probes1" Help:""   */

/* Name: Charge_State ClassID:VAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:REAL4 CType:BlockIO_Controller Struct:Controller_B.s12_Charge_State Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:-100000000000000000.000000
   Max:100000000000000000.000000 Format:4.2 UpdateID:BACKGND Group:"Controller|Foreground|Probes1" Help:""   */

/* Name: Current_Feedback_P_Gain ClassID:VAR StorageID:FLASH Access:RW4+RW3+RW2+RW1 TypeID:REAL4 CType:Constant_T Struct:ConstantWork.mh_Current_Feedback_P_Gain Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:-100000000000000000.000000
   Max:100000000000000000.000000 Format:4.2 UpdateID:BACKGND Group:"Controller|Foreground|Control" Help:""   */

/* Name: Engine_Throttle ClassID:VAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:REAL4 CType:BlockIO_Controller Struct:Controller_B.s18_Yk Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:-100000000000000000.000000
   Max:100000000000000000.000000 Format:4.2 UpdateID:BACKGND Group:"Controller|Foreground|Probes1" Help:""   */

/* Name: Motor_Torque_Request ClassID:VAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:REAL4 CType:BlockIO_Controller Struct:Controller_B.s11_Product4 Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:-100000000000000000.000000
   Max:100000000000000000.000000 Format:4.2 UpdateID:BACKGND Group:"Controller|Foreground|Probes1" Help:""   */

/* Name: Brake_request ClassID:VAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:REAL4 CType:BlockIO_Controller Struct:Controller_B.s11_Foundation_Brake_Request Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:-100000000000000000.000000
   Max:100000000000000000.000000 Format:4.2 UpdateID:BACKGND Group:"Controller|Foreground|Probes1" Help:""   */

/* Name: Battery_Connect_Command ClassID:VAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:REAL4 CType:BlockIO_Controller Struct:Controller_B.s19_Battery_Connect_Command Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:-100000000000000000.000000
   Max:100000000000000000.000000 Format:4.2 UpdateID:BACKGND Group:"Controller|Foreground|Probes1" Help:""   */

/* Name: Gen_Enable ClassID:VAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:REAL4 CType:BlockIO_Controller Struct:Controller_B.s19_Gen_Enable Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:-100000000000000000.000000
   Max:100000000000000000.000000 Format:4.2 UpdateID:BACKGND Group:"Controller|Foreground|Probes1" Help:""   */

/* Name: Motor_Enable ClassID:VAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:REAL4 CType:BlockIO_Controller Struct:Controller_B.s19_Motor_Enable Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:-100000000000000000.000000
   Max:100000000000000000.000000 Format:4.2 UpdateID:BACKGND Group:"Controller|Foreground|Probes1" Help:""   */

/* Name: Forward_LED ClassID:VAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:REAL4 CType:BlockIO_Controller Struct:Controller_B.s19_Forward_LED Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:-100000000000000000.000000
   Max:100000000000000000.000000 Format:4.2 UpdateID:BACKGND Group:"Controller|Foreground|Probes1" Help:""   */

/* Name: Park_LED ClassID:VAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:REAL4 CType:BlockIO_Controller Struct:Controller_B.s19_Park_LED Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:-100000000000000000.000000
   Max:100000000000000000.000000 Format:4.2 UpdateID:BACKGND Group:"Controller|Foreground|Probes1" Help:""   */

/* Name: Filtered_Motor_Current ClassID:VAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:REAL4 CType:BlockIO_Controller Struct:Controller_B.s13_DiscreteTransferFcn Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:-100000000000000000.000000
   Max:100000000000000000.000000 Format:4.2 UpdateID:BACKGND Group:"Controller|Foreground|Control|Charge_Current_Calculator" Help:""   */

/* Name: Speed_Feedback_I_Gain ClassID:VAR StorageID:FLASH Access:RW4+RW3+RW2+RW1 TypeID:REAL4 CType:Constant_T Struct:ConstantWork.mh_Speed_Feedback_I_Gain Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:-100000000000000000.000000
   Max:100000000000000000.000000 Format:4.2 UpdateID:BACKGND Group:"Controller|Foreground|Control" Help:""   */

/* Name: Current_Feedback_I_Gain ClassID:VAR StorageID:FLASH Access:RW4+RW3+RW2+RW1 TypeID:REAL4 CType:Constant_T Struct:ConstantWork.mh_Current_Feedback_I_Gain Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:-100000000000000000.000000
   Max:100000000000000000.000000 Format:4.2 UpdateID:BACKGND Group:"Controller|Foreground|Control" Help:""   */

/* Name: Park_LED_new ClassID:VAR StorageID:RAM Access:RW4+RW3+RW2+RW1 TypeID:REAL4 CType:Volatile_T Struct:VolatileWork.mh_Park_LED_new Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:-100000000000000000.000000
   Max:100000000000000000.000000 Format:4.2 UpdateID:BACKGND Group:"Controller|Foreground | Park_LED Override" Help:""   */

/* Name: Park_LED_ovr ClassID:ENUMVAR StorageID:RAM Access:RW4+RW3+RW2+RW1 TypeID:UINT1 CType:Volatile_T Struct:VolatileWork.mh_Park_LED_ovr Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:0.000000
   Max:1.000000 Format:1.0 UpdateID:BACKGND Group:"Controller|Foreground | Park_LED Override" Help:""  EnumDec:VarDecEnum_2 */

/* Name: Forward_LED_new ClassID:VAR StorageID:RAM Access:RW4+RW3+RW2+RW1 TypeID:REAL4 CType:Volatile_T Struct:VolatileWork.mh_Forward_LED_new Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:-100000000000000000.000000
   Max:100000000000000000.000000 Format:4.2 UpdateID:BACKGND Group:"Controller|Foreground | Forward_LED Override" Help:""   */

/* Name: Forward_LED_ovr ClassID:ENUMVAR StorageID:RAM Access:RW4+RW3+RW2+RW1 TypeID:UINT1 CType:Volatile_T Struct:VolatileWork.mh_Forward_LED_ovr Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:0.000000
   Max:1.000000 Format:1.0 UpdateID:BACKGND Group:"Controller|Foreground | Forward_LED Override" Help:""  EnumDec:VarDecEnum_2 */

/* Name: Reverse_LED_new ClassID:VAR StorageID:RAM Access:RW4+RW3+RW2+RW1 TypeID:REAL4 CType:Volatile_T Struct:VolatileWork.mh_Reverse_LED_new Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:-100000000000000000.000000
   Max:100000000000000000.000000 Format:4.2 UpdateID:BACKGND Group:"Controller|Foreground | Reverse_LED Override" Help:""   */

/* Name: Reverse_LED_ovr ClassID:ENUMVAR StorageID:RAM Access:RW4+RW3+RW2+RW1 TypeID:UINT1 CType:Volatile_T Struct:VolatileWork.mh_Reverse_LED_ovr Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:0.000000
   Max:1.000000 Format:1.0 UpdateID:BACKGND Group:"Controller|Foreground | Reverse_LED Override" Help:""  EnumDec:VarDecEnum_2 */

/* Name: Error_LED_new ClassID:VAR StorageID:RAM Access:RW4+RW3+RW2+RW1 TypeID:REAL4 CType:Volatile_T Struct:VolatileWork.mh_Error_LED_new Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:-100000000000000000.000000
   Max:100000000000000000.000000 Format:4.2 UpdateID:BACKGND Group:"Controller|Foreground | Error_LED Override" Help:""   */

/* Name: Error_LED_ovr ClassID:ENUMVAR StorageID:RAM Access:RW4+RW3+RW2+RW1 TypeID:UINT1 CType:Volatile_T Struct:VolatileWork.mh_Error_LED_ovr Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:0.000000
   Max:1.000000 Format:1.0 UpdateID:BACKGND Group:"Controller|Foreground | Error_LED Override" Help:""  EnumDec:VarDecEnum_2 */

/* Name: Vehicle_Ready_LED_new ClassID:VAR StorageID:RAM Access:RW4+RW3+RW2+RW1 TypeID:REAL4 CType:Volatile_T Struct:VolatileWork.mh_Vehicle_Ready_LED_new Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:-100000000000000000.000000
   Max:100000000000000000.000000 Format:4.2 UpdateID:BACKGND Group:"Controller|Foreground | Vehicle_Ready_LED Override" Help:""   */

/* Name: Vehicle_Ready_LED_ovr ClassID:ENUMVAR StorageID:RAM Access:RW4+RW3+RW2+RW1 TypeID:UINT1 CType:Volatile_T Struct:VolatileWork.mh_Vehicle_Ready_LED_ovr Mask:FFFFFFFF
   Gain:1.0 Offset:0.0 Exp:1.0 Min:0.000000
   Max:1.000000 Format:1.0 UpdateID:BACKGND Group:"Controller|Foreground | Vehicle_Ready_LED Override" Help:""  EnumDec:VarDecEnum_2 */

/* Name: CityID_CAN_1 ClassID:VAR StorageID:FLASH Access:RW4+NA3+NA2+NA1 TypeID:UINT1 CType:NonVolatile_T Struct:NonVolatileWork.mh_CityID_CAN_1 Mask:FFFFFFFF
   Gain:1 Offset:0 Exp:1 Min:0.000000
   Max:255.000000 Format:3.0 UpdateID:BACKGND Group:"System | System Config | Communication Config" Help:"City ID for CAN bus CAN_1"   */

/* Name: dout_create_MPRD ClassID:ENUMVAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:UINT1
   CType:E_NativeFWError Struct:dout_create_MPRD Mask:FFFFFFFF EnumDec:E_NativeFWError
   UpdateID:BACKGND Group:"System | Debug | Resources | DiscreteOut" Help:"Debug Variable" */
uint8_T dout_create_MPRD = 7;

/* Name: dout_create_FUELP ClassID:ENUMVAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:UINT1
   CType:E_NativeFWError Struct:dout_create_FUELP Mask:FFFFFFFF EnumDec:E_NativeFWError
   UpdateID:BACKGND Group:"System | Debug | Resources | DiscreteOut" Help:"Debug Variable" */
uint8_T dout_create_FUELP = 7;

/* Name: dout_create_TACH ClassID:ENUMVAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:UINT1
   CType:E_NativeFWError Struct:dout_create_TACH Mask:FFFFFFFF EnumDec:E_NativeFWError
   UpdateID:BACKGND Group:"System | Debug | Resources | DiscreteOut" Help:"Debug Variable" */
uint8_T dout_create_TACH = 7;

/* Name: dout_create_INJ1D ClassID:ENUMVAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:UINT1
   CType:E_NativeFWError Struct:dout_create_INJ1D Mask:FFFFFFFF EnumDec:E_NativeFWError
   UpdateID:BACKGND Group:"System | Debug | Resources | DiscreteOut" Help:"Debug Variable" */
uint8_T dout_create_INJ1D = 7;

/* Name: dout_create_INJ2D ClassID:ENUMVAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:UINT1
   CType:E_NativeFWError Struct:dout_create_INJ2D Mask:FFFFFFFF EnumDec:E_NativeFWError
   UpdateID:BACKGND Group:"System | Debug | Resources | DiscreteOut" Help:"Debug Variable" */
uint8_T dout_create_INJ2D = 7;

/* Name: dout_create_INJ3D ClassID:ENUMVAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:UINT1
   CType:E_NativeFWError Struct:dout_create_INJ3D Mask:FFFFFFFF EnumDec:E_NativeFWError
   UpdateID:BACKGND Group:"System | Debug | Resources | DiscreteOut" Help:"Debug Variable" */
uint8_T dout_create_INJ3D = 7;

/* Name: ain_create_ECUP ClassID:ENUMVAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:UINT1
   CType:E_NativeFWError Struct:ain_create_ECUP Mask:FFFFFFFF EnumDec:E_NativeFWError
   UpdateID:BACKGND Group:"System | Debug | Resources | AnalogIn" Help:"Debug Variable" */
uint8_T ain_create_ECUP = RESOURCE_NOT_CREATED;

/* Name: ain_read_ECUP ClassID:ENUMVAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:UINT1
   CType:E_NativeFWError Struct:ain_read_ECUP Mask:FFFFFFFF EnumDec:E_NativeFWError
   UpdateID:BACKGND Group:"System | Debug | Resources | AnalogIn" Help:"Debug Variable" */
uint8_T ain_read_ECUP = RESOURCE_NOT_CREATED;

/* Name: ain_create_AN4M ClassID:ENUMVAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:UINT1
   CType:E_NativeFWError Struct:ain_create_AN4M Mask:FFFFFFFF EnumDec:E_NativeFWError
   UpdateID:BACKGND Group:"System | Debug | Resources | AnalogIn" Help:"Debug Variable" */
uint8_T ain_create_AN4M = RESOURCE_NOT_CREATED;

/* Name: ain_read_AN4M ClassID:ENUMVAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:UINT1
   CType:E_NativeFWError Struct:ain_read_AN4M Mask:FFFFFFFF EnumDec:E_NativeFWError
   UpdateID:BACKGND Group:"System | Debug | Resources | AnalogIn" Help:"Debug Variable" */
uint8_T ain_read_AN4M = RESOURCE_NOT_CREATED;

/* Name: ain_create_AN5M ClassID:ENUMVAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:UINT1
   CType:E_NativeFWError Struct:ain_create_AN5M Mask:FFFFFFFF EnumDec:E_NativeFWError
   UpdateID:BACKGND Group:"System | Debug | Resources | AnalogIn" Help:"Debug Variable" */
uint8_T ain_create_AN5M = RESOURCE_NOT_CREATED;

/* Name: ain_read_AN5M ClassID:ENUMVAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:UINT1
   CType:E_NativeFWError Struct:ain_read_AN5M Mask:FFFFFFFF EnumDec:E_NativeFWError
   UpdateID:BACKGND Group:"System | Debug | Resources | AnalogIn" Help:"Debug Variable" */
uint8_T ain_read_AN5M = RESOURCE_NOT_CREATED;

/* Name: din_create_AN6M ClassID:ENUMVAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:UINT1
   CType:E_NativeFWError Struct:din_create_AN6M Mask:FFFFFFFF EnumDec:E_NativeFWError
   UpdateID:BACKGND Group:"System | Debug | Resources | DigitalInput" Help:"Debug Variable" */
uint8_T din_create_AN6M = RESOURCE_NOT_CREATED;

/* Name: din_read_AN6M ClassID:ENUMVAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:UINT1
   CType:E_NativeFWError Struct:din_read_AN6M Mask:FFFFFFFF EnumDec:E_NativeFWError
   UpdateID:BACKGND Group:"System | Debug | Resources | DigitalInput" Help:"Debug Variable" */
uint8_T din_read_AN6M = RESOURCE_NOT_CREATED;

/* Name: din_create_AN1M ClassID:ENUMVAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:UINT1
   CType:E_NativeFWError Struct:din_create_AN1M Mask:FFFFFFFF EnumDec:E_NativeFWError
   UpdateID:BACKGND Group:"System | Debug | Resources | DigitalInput" Help:"Debug Variable" */
uint8_T din_create_AN1M = RESOURCE_NOT_CREATED;

/* Name: din_read_AN1M ClassID:ENUMVAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:UINT1
   CType:E_NativeFWError Struct:din_read_AN1M Mask:FFFFFFFF EnumDec:E_NativeFWError
   UpdateID:BACKGND Group:"System | Debug | Resources | DigitalInput" Help:"Debug Variable" */
uint8_T din_read_AN1M = RESOURCE_NOT_CREATED;

/* Name: din_create_AN2M ClassID:ENUMVAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:UINT1
   CType:E_NativeFWError Struct:din_create_AN2M Mask:FFFFFFFF EnumDec:E_NativeFWError
   UpdateID:BACKGND Group:"System | Debug | Resources | DigitalInput" Help:"Debug Variable" */
uint8_T din_create_AN2M = RESOURCE_NOT_CREATED;

/* Name: din_read_AN2M ClassID:ENUMVAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:UINT1
   CType:E_NativeFWError Struct:din_read_AN2M Mask:FFFFFFFF EnumDec:E_NativeFWError
   UpdateID:BACKGND Group:"System | Debug | Resources | DigitalInput" Help:"Debug Variable" */
uint8_T din_read_AN2M = RESOURCE_NOT_CREATED;

/* Name: resource_allocation ClassID:ENUMVAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:UINT1
   CType:E_NativeFWError Struct:resource_allocation Mask:FFFFFFFF EnumDec:E_NativeFWError
   UpdateID:BACKGND Group:"System | Debug | Resources | Other" Help:"Debug Variable" */
uint8_T resource_allocation = 7;

/* Name: CAN_1_std_receive_count ClassID:VAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:UINT4 CType:Volatile_T Struct:VolatileWork.mh_CAN_1_std_receive_count Mask:FFFFFFFF
   Gain:1 Offset:0 Exp:1 Min:0.000000
   Max:4294967295.000000 Format:8.0 UpdateID:BACKGND Group:"System | Debug | Resources | CAN" Help:"Total number of received std CAN messages on bus CAN_1"   */

/* Name: CAN_1_std_handled_count ClassID:VAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:UINT4 CType:Volatile_T Struct:VolatileWork.mh_CAN_1_std_handled_count Mask:FFFFFFFF
   Gain:1 Offset:0 Exp:1 Min:0.000000
   Max:4294967295.000000 Format:8.0 UpdateID:BACKGND Group:"System | Debug | Resources | CAN" Help:"Total number of handled std CAN messages on bus CAN_1"   */

/* Name: CAN_1_std_last_unhandled_id ClassID:VAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:UINT4 CType:Volatile_T Struct:VolatileWork.mh_CAN_1_std_last_unhandled_id Mask:FFFFFFFF
   Gain:1 Offset:0 Exp:1 Min:0.000000
   Max:4294967295.000000 Format:8.0 UpdateID:BACKGND Group:"System | Debug | Resources | CAN" Help:"Last received std CAN message on bus CAN_1, which was unhandled"   */

/* Name: can_tx_err_CAN_1_0 ClassID:ENUMVAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:UINT1
   CType:E_NativeFWError Struct:can_tx_err_CAN_1_0 Mask:FFFFFFFF EnumDec:E_NativeFWError
   UpdateID:BACKGND Group:"System | Debug | Resources | CAN" Help:"Debug Variable" */
uint8_T can_tx_err_CAN_1_0 = 0;

/* Name: can_create_CAN_1 ClassID:ENUMVAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:UINT1
   CType:E_NativeFWError Struct:can_create_CAN_1 Mask:FFFFFFFF EnumDec:E_NativeFWError
   UpdateID:BACKGND Group:"System | Debug | Resources | CAN" Help:"Debug Variable" */
uint8_T can_create_CAN_1 = 7;

/* Name: protocol_register_CAN_1 ClassID:ENUMVAR StorageID:RAM Access:RO4+RO3+RO2+RO1 TypeID:UINT1
   CType:E_NativeFWError Struct:protocol_register_CAN_1 Mask:FFFFFFFF EnumDec:E_NativeFWError
   UpdateID:BACKGND Group:"System | Debug | Resources | CAN" Help:"Debug Variable" */
uint8_T protocol_register_CAN_1 = 7;

#include <Pragma_Section_End_sbss.h>

/*---- END OF FILE ----------------------------------------------------------------------------------------*/
